function [hdrname]=ext_img2hdr(filename)
%[hdrname]=ext_img2hdr(filename)
%convert the extension of a img file to '.hdr'.
%Input:
% filename: file name of a img file.
%Output:
% imgname: the same string as the input except that
%          the extension is '.hdr', not '.img'.
%
%20040318, jdlee
%
[path,name,ext] = fileparts(filename);

if isempty(ext),
    hdrname = fullfile(path,[name '.hdr']);    
else
    switch ext,
    case '.img',
       hdrname = fullfile(path,[name '.hdr']);
    case '.hdr',
       hdrname = filename;%do nothing
    otherwise,
       error('The input string is not a hdr or an img file name');
    end
end

return
    